<?php
/*
CLAUDIO CARDINALE 4AI
dato un file con i campi cognome, nome, data di nascita, sesso, comune di nascita
calcolare codice fiscale
*/

//acquisizione dati
$nome = isset($_GET['nome'])?$_GET['nome']:"";
$cognome = isset($_GET['cognome'])?$_GET['cognome']:"";
$sesso = isset($_GET['sesso'])?$_GET['sesso']:"";
$anno = isset($_GET['anno'])?$_GET['anno']:"";
$mese = isset($_GET['mese'])?$_GET['mese']:"";
$giorno = isset($_GET['giorno'])?$_GET['giorno']:"";
$comune = isset($_GET['comune'])?$_GET['comune']:"";
$value = isset($_GET['value'])?$_GET['value']:"";

//formattazione dati
$comune_o = $comune;
$comune = substr($comune,0,-5);
$data = $giorno."/".$mese."/".$anno;

//recupero valori per javascript
if($value!=""){
	comune_js($value);
}

function comune_js($value){
	$file = fopen("comuni","r");
	fgets($file);
	$valori = cerca($file, $value, 10);

	$stringa = "";
	foreach($valori as $corrente){
		fseek($file, $corrente);
		$str = fgets($file);
		$str = explode(";",$str);
		$str[0] = substr($str[0],1,-1);
		$str[1] = substr($str[1],1,-1);
		$stringa .= $str[0]." (".$str[1].");";
	}
	fclose($file);

	die (substr($stringa,0,-1));
}
	
function cerca($file, $ele, $limite){
	$len_ele = strlen($ele);
	$ritorno = array();
	
	for($j=0,$pos = ftell($file);($str=fgets($file))!=""&&$j<$limite;$pos=ftell($file)){
		$str = explode(";",$str);
		$str[0] = substr($str[0],1,-1);
		if(substr(strtolower($str[0]), 0, $len_ele)==strtolower($ele)){
			$ritorno[$j] = $pos;
			$j++;
		}
	}
	return $ritorno;
}
?>
<html>
<head>
<title>codice fiscale</title>
<style>
div.suggestions {
    -moz-box-sizing: border-box;
    /*box-sizing: border-box;*/
    border: 1px solid black;
    position: absolute;
}
div.suggestions div {
    cursor: default;
    padding: 0px 3px;
    background-color: #eef;
}
div.suggestions div.current {
    background-color: #6580D8;
    color: white;
}
</style>
<script type="text/javascript" src="comuni.js"></script> 
<script type="text/javascript" language="javascript">
var meseg = <?=($mese!=""?$mese:-1)?>;
var giornog = <?=($giorno!=""?$giorno:-1)?>;
function bisestile(anno){
	if((!(anno % 4) && anno % 100) || !(anno % 400))
		return true;
	return false;
}

function carica_mese(){
	var anno = document.getElementById("anno");
	var mese = document.getElementById("mese");
	var mesi = new Array( 'Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno', 'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre' );
	var data = new Date();
	var limite = 0;
	if(anno.value<1900){
		while(mese.options.length)
			mese.remove(0);
		mese.options[0] = new Option("selezionare prima un anno...","0",false,false);
	}else{
		while(mese.options.length)
			mese.remove(0);
		mese.options[0] = new Option("selezionare un mese...","0",false,false);
		if((data.getYear()+1900)==anno.value)
			limite = data.getMonth()+1;
		else
			limite = 12;
		for(i=1;i<=limite;i++)
			mese.options[i] = new Option(mesi[i-1],i,false,meseg==i?true:false);
	}
	meseg = -1;
}

function carica_giorno(){
	var anno = document.getElementById("anno");
	var mese = document.getElementById("mese");
	var giorno = document.getElementById("giorno");
	var data = new Date();
	var limite = 0;
	var giorni = new Array(31,(bisestile(anno.value)?29:28),31,30,31,30,31,31,30,31,30,31)
	if(mese.value<1){
		while(giorno.options.length)
			giorno.remove(0);
		giorno.options[0] = new Option("selezionare prima un mese...","0",false,false);
	}else{
		while(giorno.options.length)
			giorno.remove(0);
		giorno.options[0] = new Option("selezionare un giorno...","0",false,false);
		if((data.getYear()+1900)==anno.value && (data.getMonth()+1)==mese.value)
			limite = data.getDate();
		else
			limite = giorni[mese.value-1];
		for(i=1;i<=limite;i++)
			giorno.options[i] = new Option(i,i,false,giornog==i?true:false);
	}
	giornog = -1;
}

window.onload = function () {
	var oTextbox = new AutoSuggestControl(document.getElementById("comune"), new Dati);
	carica_mese();
	carica_giorno();
}
</script>
</head>
<body>
<?php
if($nome!="" && $cognome!="" && $sesso!="" && $giorno!="" && $giorno!=0 && $mese!="" && $mese!=0 && $anno!="" && $anno!=0 && $comune!=""){
	$cod = "";
	$cod .= calcola_cognome($cognome);
	$cod .= calcola_nome($nome);
	$cod .= calcola_data_e_sesso($data, $sesso);
	$cod .= calcola_comune($comune);
	$cod .= calcola_controllo($cod);
	
	print "codice fiscale : ".$cod."\n";
}

//calcolo del cognome
function calcola_cognome($cognome){
	$cognome = strtoupper($cognome);
	$cognome = str_replace(" ", "", $cognome);
	$vocali = array();
	$str = "";
	
	for($i=0; $i<strlen($cognome) && strlen($str)<3; $i++)
		if(vocale($cognome[$i]))
			$vocali[] = $cognome[$i];
		else
			$str .= $cognome[$i];
	
	if(strlen($str)<3)
		for($i = 0; $i<count($vocali) && strlen($str)<3; $i++)
			$str .= $vocali[$i];
	
	if(strlen($str)<3)
		while(strlen($str)<3)
			$str .= "X";
	
	return $str;
}

//calcolo del nome
function calcola_nome($nome){
	$nome = strtoupper($nome);
	$nome = str_replace(" ", "", $nome);
	$consonanti = array();
	$vocali = array();
	$str = "";
	
	for($i=0; $i<strlen($nome); $i++)
		if(vocale($nome[$i]))
			$vocali[] = $nome[$i];
		else
			$consonanti[] = $nome[$i];
	if(count($consonanti)>=4)
		$str = $consonanti[0].$consonanti[2].$consonanti[3];
	else
		for($i = 0; $i<3 && $i<count($consonanti); $i++)
			$str .= $consonanti[$i];
	
	if(strlen($str)<3)
		for($i = 0; $i<count($vocali) && strlen($str)<3; $i++)
			$str .= $vocali[$i];
	
	if(strlen($str)<3)
		while(strlen($str)<3)
			$str .= "X";
	
	return $str;
}

//calcolo della data di nascita e del sesso
function calcola_data_e_sesso ($data, $sesso){
	$data = explode("/", $data);
	$sesso = strtoupper($sesso);
	$str = "";
	
	//allineamento
	$data[0] = str_pad($data[0], 2, "0", STR_PAD_LEFT);
	$data[1] = str_pad($data[1], 2, "0", STR_PAD_LEFT);
	
	//anno
	$str .= $data[2][2].$data[2][3];
	
	//mese
	$str .= mese($data[1]);
	
	//giorno e sesso
	if($sesso=="F")
		$str .= ($data[0]+40);
	else
		$str .= $data[0];
	
	return $str;
}

//calcolo del codice del comune
function calcola_comune($comune){
	$comune = strtoupper($comune);
	$f = @fopen(dirname(__FILE__)."/comuni", "r") or die("errore nell'apertura del file comuni");
	
	fgets($f);
	$flag = 0;
	while(!$flag && ($str=fgets($f))!=""){
		$str = explode(";", $str);
		if(trim($str[0]) ==  "\"".trim($comune)."\"")
			$flag = 1;
	}
	
	fclose($f);
	
	if($flag)
		return substr(trim($str[2]), 1, -1);
	else
		return "ERRR";
}

//calcolo del carattere di controllo
function calcola_controllo($cod){
	//inizializzazioni
	$caratteri_p = array();
	$caratteri_d = array();
	$somma_p = 0;
	$somma_d = 0;
	$valori_p = array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25);
	$valori_d = array(1, 0, 5, 7, 9, 13, 15, 17, 19, 21, 1, 0, 5, 7, 9, 13, 15, 17, 19, 21, 2, 4, 18, 20, 11, 3, 6, 8, 12, 14, 16, 10, 22, 25, 24, 23);
	
	//divisione caratteri pari/dispari
	for($i=0; $i<15; $i++)
		if($i%2)
			$caratteri_p[] = $cod[$i];
		else
			$caratteri_d[] = $cod[$i];
	
	//conversioni
	for($i=0; $i<count($caratteri_p); $i++)
		$somma_p += converti($caratteri_p[$i], $valori_p);
	
	for($i=0; $i<count($caratteri_d); $i++)
		$somma_d += converti($caratteri_d[$i], $valori_d);
	$somma = $somma_p+$somma_d;
	
	//ritorno
	return chr(65+$somma%26);
}

//controllo se è una vocale
function vocale($lettera){
	$lettera = strtoupper($lettera);
	if($lettera == "A" || $lettera == "E" || $lettera == "I" || $lettera == "O" || $lettera == "U")
		return true;
	return false;
}

//ritorno il valore letterale del mese
function mese($mese){
	$lettere = array("A", "B", "C", "D", "E", "H", "L", "M", "P", "R", "S", "T");
	return $lettere[$mese-1];
}

//conversione dei caratteri in base a dei valori passati come parametro
function converti($val, $valori){
	$val_v= $val;
	$val = strtoupper($val);
	ord($val);
	if(!is_numeric($val))
		$val = 10+ord($val)-65;
	
	return $valori[$val];
}
?>
<form action="">
<table>
<tr>
<td>nome:</td>
<td><input type="text" name="nome" value="<?=$nome?>" /></td>
</tr>
<tr>
<td>cognome:</td>
<td><input type="text" name="cognome" value="<?=$cognome?>" /></td>
</tr>
<tr>
<td>sesso</td>
<td>
<label for="m">maschio</label><input type="radio" name="sesso" id="m" value="m" <?=strtoupper($sesso)!="F"?"checked=\"checked\"":""?> />
<label for="f">femmina</label><input type="radio" name="sesso" id="f" value="f" <?=strtoupper($sesso)=="F"?"checked=\"checked\"":""?> />
</td>
</tr>
<td>data di nascita:</td>
<td>
<select name="anno" id="anno" onChange="carica_mese();carica_giorno()">
<option value="0">selezionare un anno...</option>
<?php
for($i=1900;$i<=date("Y");$i++)
	print "<option value=\"$i\"".($anno==$i?" selected=\"selected\"":"").">$i</option>\n";
?>
</select>
<select name="mese" id="mese" onChange="carica_giorno()">
<option value="0">selezionare prima un anno...</option>
</select>
<select name="giorno" id="giorno">
<option value="0">selezionare prima un mese...</option>
</select>
</td>
</tr>
<td>comune:</td>
<td><input type="text" name="comune" id="comune" value="<?=$comune_o?>" autocomplete="off" size="50" /></td>
</tr> 
<tr>
<td colspan="2" align="center"><input type="submit" value="calcola" /></td>
</tr>
</table>
</form>
</body>
</html>
