<?php
/************************************************************
copyrigth Claudio cardinale 2004-2011 tutti i diritti riservati
contatti: 	cardi@thecsea.it(o http://www.thecsea.it)
versione :	1.3.9
data:		27/03/2011 20:26
*************************************************************/
require_once "mysql.php";
class Spec{
	//proprieta private
	private $mysql = "";
	private $table_c = "";
	private $table_m = "";
	private $giorni_settimana = array("Domenica","Luned&igrave;","Marted&igrave;","Mercoled&igrave;","Gioved&igrave;","Venerd&igrave;","Sabato");
	
	//proprieta pubbliche
	public $fine= array();
	
	//costruttore
	public function __construct(){
		include "config.inc.php";
		$this->mysql = new mysql($db_host,$db_user,$db_password,$db_name);
		$this->table_c = $table_c;
		$this->table_m = $table_m;
		$this->sito_s = $sito_s;
		$this->url_s = $url_s;
		$this->password_s = $password_s;
		$this->fine = $fine;
	}
	
	//metodi privati
	
	private function cerca($vet,$ele){
		for($i=0;$i<count($vet) && $vet[$i]!=$ele;$i++);
		
		if($i<count($vet) && $vet[$i]==$ele)
			return $i;
		return -1;
	}
	
	private function copia_v($mat,$pos){
		for($i=0;$i<count($mat);$i++)
			$vet[$i] = $mat[$i][$pos];
		return $vet;
				
	}
	
	private function invia($server, $porta, $pagina, $dati){
		$ses = curl_init("http://".$server.":".$porta."/".$pagina);
		curl_setopt ($ses, CURLOPT_POST, true); 
		curl_setopt ($ses, CURLOPT_POSTFIELDS, $dati);
		curl_setopt($ses, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ses, CURLOPT_CONNECTTIMEOUT, 1);
		curl_setopt($ses, CURLOPT_TIMEOUT, 10);
		$response = curl_exec($ses);
		curl_close($ses);
		return $response;
	}
	
	//metodi pubblici
	
	public function read($giorno){
		$data = getdate($giorno);
		$results = $this->mysql->elenca ("id,data,materia,compito","data >= $giorno AND data <= ".(mktime(0,0,0,$data['mon'],$data['mday']+1,$data['year'])-1)." AND valido=1","data","ASC",$this->table_c,1);
		if(!($results===false)){
			$materie = $this->mysql->elenca ("id,materia","1 = 1","id","ASC",$this->table_m,1);
			$id_materie = $this->copia_v($materie,0);
			for($i=0;$i<count($results);$i++){
				$cerca = $this->cerca($id_materie,$results[$i][2]);
				if($cerca == -1)
					$results[$i][2] = "materia inesistente";
				else
					$results[$i][2] = $materie[$cerca][1];
				$results[$i][3] = $this->bbcode($results[$i][3]);
			}
		
			return $results;
		}
		return false;
	}
	
	public function write($data, $materia, $compito){
		/*$materie = $this->mysql->elenca ("id,materia","1 = 1","id","ASC",$this->table_m,1);
		$t_materie = copia_v($materie,1);
		$materia = $materie[(cerca($t_materie,$materia))][0];*/
		//$materia = $this->mysql->leggi("id","materia = '$materia'",$this->table_m);
		return $this->mysql->inserisci ("data, materia, compito", "$data, $materia, '$compito'", $this->table_c);
	}
	
	public function read_m(){
		return $this->mysql->elenca ("id,materia","1 = 1","materia","ASC",$this->table_m,1);
	}
	
	public function read_e($id){
		return $this->mysql->elenca("data, materia, compito","id = $id","id","ASC",$this->table_c,0);
	}
	
	public function materia_da_id($id){
		return $this->mysql->leggi("materia","id = $id",$this->table_m);
	}
	
	public function elimina($id){
		return $this->mysql->aggiorna ("valido", "0", $this->table_c, "id = $id");
		//return $this->mysql->elimina("id = $id",$this->table_c);
	}
	
	public function modifica($id, $data, $materia, $compito){
		return $this->mysql->aggiorna ("data, materia, compito", "'$data', '$materia', '$compito'", $this->table_c, "id = $id");
	}
	
	public function check_sql($text){
		//$text = str_replace(array("<",">"),array("&lt;","&gt;"),$text);
		$text = htmlentities($text,ENT_QUOTES,"utf-8");
		return mysql_escape_string($text);
	}
	
	public function nome_giorno($giorno_sett){
		if($giorno_sett >= 0 && $giorno_sett <= 6)
			return $this->giorni_settimana[$giorno_sett];
		return false;
	}
	
	public function bbcode($stringa){
		$stringa = str_replace(array("  ","\n"),array("&nbsp;&nbsp;","<br />"),$stringa);		
		return preg_replace("#\[colorato\](.*?)\[/colorato\]#","<span style=\"color:red;\">$1</span>",$stringa);
	}
	
	public function sincronizza(){
		$str = "<table>\n";
		$data = getdate();
		$limite = round((mktime(0,0,0,$this->fine[1],$this->fine[0],$this->fine[2])-mktime(0,0,0,$data['mon'],$data['mday'],$data['year']))/86400+1);
		$limite = $limite<7?$limite:7;
		for($k=0;$k<$limite;$k++){
			$giorno = mktime(0,0,0,$data['mon'],$data['mday']+$k,$data['year']);
			$str .= "<tr>\n<td colspan=\"2\">".$this->nome_giorno(date("w", $giorno))." ".date("(d - m - Y)", $giorno)." :</td>\n</tr>\n";
			$results = $this->read($giorno);
			if($results === false)
				$str .= "<tr>\n<td colspan=\"2\">niente</td>\n</tr>\n";
			else
				for($i=0;$i<count($results);$i++)
					$str .= "<tr>\n<td>".date("H:i",$results[$i][1])."&nbsp;".$results[$i][2]."</td>\n<td>".$results[$i][3]."</td>\n</tr>\n";
		}
		$str .= "</table><br/ >\nultimo aggiornamento : ".date("d/m/Y H:i:s");
		return $this->invia($this->sito_s, "80", $this->url_s."?pass=".urlencode($this->password_s), "data=".urlencode($str));

	}
	
	public function p_null($name){
		return isset($_POST[$name])?$_POST[$name]:"";
	}
	
	public function g_null($name){
		return isset($_GET[$name])?$_GET[$name]:"";
	}
	
	public function r_null($name){
		return isset($_REQUEST[$name])?$_REQUEST[$name]:"";
	}
}
?>
