<?
/************************************************************
copyrigth Claudio Cardinale 2004-2014 tutti i diritti riservati
contatti: 	cardi@thecsea.it(o http://www.thecsea.it)
versione :	2.1.0
data:		22/10/2014 12:53

per scaricare l'ultima versione andare
su http://www.thecsea.it/progetti/classi_db
non eliminare il copyright e ridistribuire
sempre il codice accompagnato dalla licenza GNU
****************************************************************/
define("ALL_DEBUG_CON", false); //se true mostro più errori e maggiori dettagli
define("NO_DIE", false); //se true invece di effettuare un die in caso di errori gravi viene generata un'eccezione

//classe con metodi di acceso al db, passare come parametri $db_host,$db_user,$db_password,$db_name
class Mysql_c{ 
	//proprieta' private
	private $db_host = "";
	private $db_user = "";
	private $db_password = "";
	private $db_name = "";
	private $mysqli_ref= "";
	
	//proprieta' pubbliche
	public $db = "";
	public $debug = false;

	public function __construct($db_host = "", $db_user = "", $db_password = "", $db_name = "", $key = NULL, $cert =  NULL, $ca = NULL) {
		//assegnazione proprieta'
		//controllo che i parametro della funzione non siano nulli
		if ($db_host != "")
			$this->db_host = $db_host;

		if ($db_user != "")
			$this->db_user = $db_user;

		if ($db_password != "")
			$this->db_password = $db_password;

		if ($db_name != "")
			$this->db_name = $db_name;
		
		//connessione al db
		
		$this->mysqli_ref = mysqli_init();
		
		if($key != NULL && $cert != NULL && $ca != NULL){
			$this->mysqli_ref->ssl_set($key, $cert, $ca, null, null);
			$connected =@$this->mysqli_ref->real_connect($db_host,
                                   $db_user,
                                   $db_password,
                                   $db_name,
                                   3306,
                                   null,
                                   MYSQLI_CLIENT_SSL);
		}else{
			$connected =@$this->mysqli_ref->real_connect($db_host,
                                   $db_user,
                                   $db_password,
                                   $db_name);
		}

		//$this->mysqli_ref = @new mysqli($this->db_host, $this->db_user, $this->db_password, $this->db_name);
		
		//errore durante la connessione
		if (!$connected || $this->mysqli_ref->connect_error) 
			if(NO_DIE)
				throw new Exception('Database connection error (' . $this->mysqli_ref->connect_errno . ') '. ((ALL_DEBUG_CON)?($this->mysqli_ref->connect_error):""));
			else
				die('Database connection error (' . $this->mysqli_ref->connect_errno . ') '. ((ALL_DEBUG_CON)?($this->mysqli_ref->connect_error):""));
		
		//connessione per link $this->db da usare in funzioni esterne come ad esempio mysql_real_escape_string ATTENZIONE: nelle prossime versioni potrebbe non essere piu' supportato
		if(NO_DIE){
			if(!($this->db = @mysql_connect($this->db_host, $this->db_user, $this->db_password, $this->db_name)))
				throw new Exception("Database connection error");
		}else
			$this->db = @mysql_connect($this->db_host, $this->db_user, $this->db_password, $this->db_name) or die ("Database connection error");
		
		/*
		$this->db = @mysql_connect($db_host, $db_user, $db_password) or die ("Connessione al database non riuscita");
		@mysql_select_db($db_name, $this->db) or die ("Selezione del database non riuscita");*/
	}
	
	public function __destruct(){
		@$this->mysqli_ref->close();
	}
	
	//metodi privati
	
	//ritorna la stringa sostituendo all'interno degli apici il carattere "," con \virgola e "'" con \apice
	private function metti_escape_virgola($stringa){
		$stringa = str_replace("\\","\\/",$stringa);
		$stringa = str_replace("\\/'","\\apice",$stringa);

		//eventualmente considerare divisori anche i doppi apici
		$len =  strlen($stringa);
		$apice = false;
		$str = "";
		for($i=0; $i<$len; $i++)
			if($stringa[$i] == "'"){
				if($apice)
					$apice = false;
				else
					$apice = true;
				$str .= $stringa[$i];
			}else if($stringa[$i] == ",")
				if($apice)
					$str .= "\\virgola";
				else
					$str .= $stringa[$i];
			else
					$str .= $stringa[$i];
		
		return $str;
	}
	
	//toglie gli escape per la virgola e gli apici
	private function togli_escape_virgola($stringa){
		$stringa = str_replace("\\virgola",",",$stringa);
		$stringa = str_replace("\\apice","\\/'",$stringa);
		return str_replace("\\/","\\",$stringa);
	}
	
	//unisce le diverse insert omogenne di un array
	private function insert_da_array($array,$newline=false){
		return ("(".implode("),".($newline?"\n":"")."(",(array)$array).")");
	}
	
	//metodi pubblici
	
	//esegue una guery
	public function esegui($query,$return=true){
		if($this->debug)
			print $query."<br />\n";
		$results = $this->mysqli_ref->query($query);
		if (!$results){
			if($this->debug)
				print "ERR";
			return false;
		}else
			if($return===true)
				return $results;
			else
				return true;
	}
	
	//inserisce un record nel database, in caso di righe multiple inserirle normalmente ma tramite un array, esmepio: array("'elemento11','elemento12'","'elemento21','elemento22'")
	public function inserisci ($campo, $valore, $table){
		if (($this->esegui("INSERT INTO `$table` ($campo) VALUES ".$this->insert_da_array($valore).";",false))===true)
			return true;
		else
			return false;
	}
	
	//ritorna il primo valore incrontrato nel database con una determinata condizione, se $return_null = true quando non ci sono elementi da leggere la funzione ritornerà NULL invece di false
	public function leggi ($valore_ritornato,$condizione,$table,$apici_table=true, $return_null=false){
		//query
		if($apici_table!==false)
			$result = $this->esegui("SELECT $valore_ritornato FROM `$table` WHERE $condizione;");
		else
			$result = $this->esegui("SELECT $valore_ritornato FROM $table WHERE $condizione;");
		
		//query error
		if($result === false)
			return false;
		
		//check data
		if(($row = $result->fetch_array())!==NULL){
			$result->free();
			$valore_ritornato = explode(".",$valore_ritornato);
			$valore_ritornato = $valore_ritornato[count($valore_ritornato)-1];
			return $row[$valore_ritornato];
		}
		
		//return err for no data
		return ($return_null?NULL:false);
	}

	//aggiorna un valore nel database
	public function aggiorna ($campo, $valore, $table, $condizione){
		//divisione dei parametri da aggiornare
		if(gettype($valore) !== "array"){
			$valore = $this->metti_escape_virgola($valore);
			$valore = explode(",",$valore);
		}
		$campo = explode(",",$campo);
		$len = count($campo);
		$set = "";
		for($i=0;$i<$len;$i++){
			$set .= $campo[$i]."=".$this->togli_escape_virgola($valore[$i]);
			if($i<($len-1))
				$set .= ",";
		}
		
		//agiornamento
		if ($results=$this->esegui("UPDATE `$table` SET $set WHERE $condizione;",false)===true)
			return true;
		return false;
	}
	
	//ritorna un elenco di valori incrontrati nel database con una determinata condizione, s ass= true e mat = false, ritorna solo la prima riga, se $return_null = true quando non ci sono elementi da leggere la funzione ritornerà NULL invece di false
	public function elenca ($campo_ritornato,$condizione,$ordine,$tipo_ordine,$table,$mat=false,$ass=false, $apici_table=true, $return_null=false){
		if($apici_table!==false)
			$result = $this->esegui("SELECT $campo_ritornato FROM `$table` WHERE $condizione ORDER BY $ordine $tipo_ordine;");
		else
			$result = $this->esegui("SELECT $campo_ritornato FROM $table WHERE $condizione ORDER BY $ordine $tipo_ordine;");
		$i = 0;
		$rit = false;
		if($result!==false){
			if($return_null)
				$rit = NULL;
			//non associativo
			if($ass==false)
				while ($row = $result->fetch_array())
					//matrice
					if($mat){
						for ($j =0; $j<count($row)/2;$j++ )
							$rit[$i][$j]=$row[$j];
						$i++;
					}
					//no matrice
					else
						for ($j =0; $j<count($row)/2;$j++ )
							$rit[$i++]=$row[$j];
			//associativo
			else
				while ($row = $result->fetch_array()){
					$j = 0;
					//matrice
					if($mat){
						foreach($row as $key=>$value)
							if($j++%2)
								 $rit[$i][$key] = $value;	
						$i++;
					}
					//no matrice
					else{
						foreach($row as $key=>$value)
							if($j++%2)
								 $rit[$key] = $value;
						break;
					}
				}
		}
		
		//libero la memoria
		if($rit!==false)
			$result->free();
		
		//return
		return $rit;
	}
	
	//elimina una serie di valori dal database con una determinata condizione
	public function elimina ($condizione,$table){
		if (($this->esegui("DELETE FROM `$table` WHERE $condizione;",false))===true&&$this->mysqli_ref->affected_rows)
			return true;
		else
			return false;
			
	}
	
	//elimina una tabella dal databse
	public function elimina_tabella ($table){
		if (($this->esegui("DROP TABLE `$table`;",false))===true)
			return true;
		else
			return false;
	}
	
	//ritorna le info di una tabella
	public function info ($valore_ritornato,$table){
		$result = $this->esegui("show table status like '$table';");
		if($result !== false && ($row = $result->fetch_array())!==false){
			$ret = isset($row[$valore_ritornato])?$row[$valore_ritornato]:false;
			if($ret!==false)
				$result->free();
			return $ret;
		}
		return false;
	}
	
	//ritorna l'elenco delle tabelle del database selezionato nel costruttore
	public function elenca_tabelle(){
		$result = $this->esegui("SHOW TABLES;");
		$ret = false;
		
		//inserisco i risultati in un array
		if($result!==false){
			$i=0;
			while ($row = $result->fetch_array())
				$ret[$i++]=$row[0];
		}
		
		//libero la memoria
		if($ret!==false)
			$result->free();
		
		//return
		return $ret;
	}
	
	//ritorna l'elenco dei databases
	public function elenca_databases(){
		$result = $this->esegui("SHOW DATABASES;");
		$ret = false;
		
		//inserisco i risultati in un array
		if($result!==false){
			$i=0;
			while ($row = $result->fetch_array())
				$ret[$i++]=$row[0];
		}
		
		//libero la memoria
		if($ret!==false)
			$result->free();
		
		//return
		return $ret;
	}
		
	//ultimo id inserito
	public function ultimo_id_inserito(){
		return $this->mysqli_ref->insert_id;
	}
	
	//escape string
	public function escape_string($str){
		return $this->mysqli_ref->real_escape_string ($str);
	}
	
	//backup di una tabella
	public function backup_tabella($table){
		//inizializzazioni
		$ret = "";
		$campi = array();
		$valori = array();
		$valori2 = array();
		
		//create table
		$result = $this->esegui("SHOW CREATE TABLE `$table`;");
		if($result !== false && ($row = $result->fetch_array())!==false && isset($row['Create Table']))
			$ret .= $row['Create Table'].";";
		else
			return false;
		
		//select
		if(($valori = $this->elenca("*","1","1","asc",$table,true,true))===false)
			return $ret;
		
		//campi
		foreach($valori[0] as $key=>$value)
			$campi[] = $key;
		$campi = "`".implode("`,`",$campi)."`";
		
		//valori
		foreach($valori as $value)
			$valori2[] = "'".implode("','",$value)."'";
		
		//insert
		$ret .= "\nINSERT INTO `$table` ($campi) VALUES ".$this->insert_da_array($valori2,true).";\n";
		
		//libero la memoria
		if($ret!==false)
			$result->free();

		
		//return
		return $ret;
	}
}

//alias del vecchio nome ATTENZIONE: nelle prossime versioni potrebbe non essere piu' supportato
class_alias("Mysql_c", "Mysql");
?>